<?php

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

class VideosController extends AppController {
	var $name = 'Videos';
	var $helpers = array('Captcha','Html','Form','Time','Javascript','Rss');
	var $components = array('Captcha','RequestHandler');
	
	function index()
	{		
		$category_id = array();
		
		$this->Video->Category->recursive = -1;
		$category_homepage = $this->Video->Category->find('all', array('conditions' => array('homepage' => 1)));
				
		foreach($category_homepage as $cat_homepage) {
			
			$cat_id[] = $cat_homepage['Category']['id'];
		}
		//$cat_id = implode(",",$category_id);
		
		$categories = $this->Video->find('all', array('conditions' => array('category_id' => $cat_id)));

		foreach($categories as $category) {
			$vidoes = array();
			$order = "Video.id DESC";				
			$this->Video->recursive = 1;
			$videos[$category['Category']['name']] = $this->Video->find('all', array('conditions' => array('category_id' => $category['Category']['id']),'order' => array($order),'limit' => Configure::read('MyApp.record_per_page')));
			$this->set(compact('videos'));
		}
		
		$this->set('title_for_layout',Configure::read('MyApp.site_title'));
		$this->set('keywords_for_layout',Configure::read('MyApp.site_keywords'));
		$this->set('description_for_layout',Configure::read('MyApp.site_description'));
	}
	
	
	function videos_by_type($type) {
		if($type == 'recent') {			
			$order = 'Video.id DESC';
			$title = "Recent Videos";
			$this->set('page_name',"recent");
		}
		
		if($type == "most_viewed") {
			$order = 'Video.viewed DESC';
			$title = "Most Viewed Videos";
			$this->set('page_name',"most_viewed");
		}
		$this->set('category_name',"Recent Videos");
		$this->paginate = array('limit' => Configure::read('MyApp.record_per_page'),'order' => array($order));
		$videos = $this->paginate('Video');
		$this->set(compact('videos'));
		
		$this->set('title_for_layout',$title);
		$this->set('keywords_for_layout','');
		$this->set('description_for_layout','');
		
		$this->render('/categories/video_by_category');		
	}
	
	function view($name = '',$id = '') {
		if($id == '' || $name == '') {
			$this->redirect('/');
		}		
		$videos = $this->Video->find('first',array('conditions' => array('Video.id' => $id,'Video.machine_name' => $name)));
		
		if(empty($videos)) {
			$this->redirect('/');
		}

		$id = $this->Video->id = $videos['Video']['id'];
		$this->Video->saveField('viewed',$videos['Video']['viewed']+1);
		
		//Update view by one in display manually
		$videos['Video']['viewed'] = $videos['Video']['viewed'] + 1;
		
		$this->set(compact('videos'));
		
		$this->paginate = array('conditions' => array('Comment.status' => 'active','Comment.video_id' => $id),'limit' => Configure::read('MyApp.record_per_page'),'order' => array('Comment.id ASC'));
		$comments_array = $this->paginate('Comment');
		$this->set(compact('comments_array'));
		
		$page_title = ($videos['Video']['page_title'] == "") ? $videos['Video']['name'] : $videos['Video']['page_title'];
		$page_keywords = ($videos['Video']['page_keyword'] == "") ? "" : $videos['Video']['page_title'];
		$page_description = ($videos['Video']['page_description'] == "") ? "" : $videos['Video']['page_description'];
		
		$this->set('title_for_layout',$page_title);
		$this->set('keywords_for_layout',$page_keywords);
		$this->set('description_for_layout',$page_description);
	}
	
	function admin_view() {
		$this->paginate = array('conditions' => array(),'limit' => Configure::read('MyApp.record_per_page'));
		$videos = $this->paginate('Video');
		$this->set(compact('videos'));
		$this->set('path_name','videos');
	}
	
	function admin_add() {
		if(!empty($this->data)) {
			$this->Video->set($this->data);
			if($this->Video->validates())
			{				
				$this->data['Video']['machine_name'] = $this->SeoUrl->makeShortUrl($this->data['Video']['name']);
				$this->Video->create();
				if($this->Video->save($this->data)) {
					$this->Session->setFlash('Video Created Successfully');
				}
				else {
					$this->Session->setFlash('There is a problem in creating new video');
				}
			}
			else {
				$this->Session->setFlash('Form validation failed');
			}			
		}
		$categories = $this->Video->Category->find('all');
		$this->set(compact('categories'));
		$this->set('path_name','videos');
	}
	
	function admin_edit($id = '') {
		if($id == "") {
			$this->redirect('/admin/videos/view');
		}
		if(!empty($this->data)) {
			$this->Video->create();
			if($this->Video->save($this->data)) {
				$this->Session->setFlash('Video editted Successfully');
			}
			else {
				$this->Session->setFlash('There is a problem in editting video');
			}				
		}
		$videos = $this->data = $this->Video->findById($id);
		$this->set(compact('videos'));
		$categories = $this->Video->Category->find('all');
		$this->set(compact('categories'));
		$this->set('path_name','videos');
	}
	
	
	function admin_delete($id = '') {
		if($id == "") {
			$this->redirect('/admin/videos/view');
		}
		if($this->Video->delete($id)) {
			$this->Session->setFlash('Video deleted Successfully');
			$this->redirect('/admin/videos/view');
		}
		else {
			$this->Session->setFlash('Video not deleted');
			$this->redirect('/admin/videos/view');
		}
	}
	
	function admin_index() {
		
		if (!function_exists('curl_init')){
			die('Sorry cURL is not installed to check the latest version!');
		}		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://www.agrizlive.com/tube_version.php");
		curl_setopt($ch, CURLOPT_REFERER, $_SERVER['SERVER_NAME']);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);

		$output = curl_exec($ch);
		curl_close($ch);
		
		$this->set('path_name','index');
		$this->set('version',$output);
	}
	
	function search() {
		if($this->params['form']['keyword'] == "") {$this->redirect('/');}
		$this->redirect('/search_results/'.$this->params['form']['keyword']);
	}
	
	function search_results($keyword = '') {
		if($keyword == '') {
			$this->redirect('/');
		}		
		
		$this->paginate = array('conditions' => array('Video.name LIKE ' => '%'.$keyword.'%'),'limit' => Configure::read('MyApp.record_per_page'));
		$videos = $this->paginate('Video');
		$this->set(compact('videos'));
		$this->set('page_name','search_results');
		
		$this->set('title_for_layout',"Search results for ".$keyword);
		$this->set('keywords_for_layout','');
		$this->set('description_for_layout','');
	
		$this->set('category_name',"Search Results");	
		$this->render('/categories/video_by_category');	
	}
	
}
?>